<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class UserOrganization extends Model 
{

    protected $table = 'mp_user_organization';
    public $timestamps = true;
    protected $fillable = array('user_id', 'organization_id', 'status', 'created_by', 'updated_by');

    public function fk_user_id()
    {
        return $this->belongsTo('Users', 'id');
    }

    public function fk_organization_id()
    {
        return $this->belongsTo('OrganizationLocation', 'id');
    }

}